﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IForegroundLockTimeoutStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class ForegroundLockTimeoutDefaultStrategy : ICorrespondenceOS, IForegroundLockTimeoutStrategy
    {
        public ForegroundLockTimeoutDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG                              
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "ForegroundLockTimeout";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Control Panel\Desktop");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Control Panel\Desktop");

            return new WFRegistry(@"HKEY_CURRENT_USER\Control Panel\Desktop", RegName,
                              registryKey.GetValue(RegName, 90), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class ForegroundLockTimeoutController
    {
        public ForegroundLockTimeoutController(ForegroundLockTimeout foregroundLockTimeout,
                                                         IForegroundLockTimeoutStrategy strategy)
        {
            ForegroundLockTimeout = foregroundLockTimeout;
            Strategy = strategy;
        }

        public ForegroundLockTimeout ForegroundLockTimeout { get; set; }
        public IForegroundLockTimeoutStrategy Strategy { get; set; }

        public void Read()
        {
            ForegroundLockTimeout.SetMenuShowDelayValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(ForegroundLockTimeout.GetMenuShowDelayValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
